/*
 * PropertyListUtils.java
 *
 * Created on March 3, 2003, 12:21 PM
 * 
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */

package nom.DannyBrewer.utils;

/**
 *
 * @author  danny brewer
 */
public class PropertyListUtils {
	private PropertyListUtils() { }
	
	
    //----------------------------------------------------------------------
    //  Convenience methods to access properties as well known types
    //----------------------------------------------------------------------

	
	static public int getIntProperty( PropertyList propList, String propName ) {
		return getIntProperty( propList, propName, 0 );
	}
	
	static public int getIntProperty( PropertyList propList, String propName, int defaultValue ) {
		Integer value = (Integer) propList.getProperty( propName );
		if( value == null ) {
			return defaultValue;
		} else {
			return value.intValue();
		}
	}
	
	static public void setIntProperty( PropertyList propList, String propName, int value ) {
		propList.setProperty( propName, new Integer( value ) );
	}
	
	
	
	static public long getLongProperty( PropertyList propList, String propName ) {
		return getLongProperty( propList, propName, 0 );
	}
	
	static public long getLongProperty( PropertyList propList, String propName, long defaultValue ) {
		Long value = (Long) propList.getProperty( propName );
		if( value == null ) {
			return defaultValue;
		} else {
			return value.longValue();
		}
	}
	
	static public void setLongProperty( PropertyList propList, String propName, long value ) {
		propList.setProperty( propName, new Long( value ) );
	}
	
	
	
	static public String getStringProperty( PropertyList propList, String propName ) {
		return getStringProperty( propList, propName, "" );
	}
	
	static public String getStringProperty( PropertyList propList, String propName, String defaultValue ) {
		String value = (String) propList.getProperty( propName );
		if( value == null ) {
			return defaultValue;
		} else {
			return value;
		}
	}
	
	static public void setStringProperty( PropertyList propList, String propName, String value ) {
		propList.setProperty( propName, value );
	}
	
	
	
	static public boolean getBooleanProperty( PropertyList propList, String propName ) {
		return getBooleanProperty( propList, propName, false );
	}
	
	static public boolean getBooleanProperty( PropertyList propList, String propName, boolean defaultValue ) {
		Boolean value = (Boolean) propList.getProperty( propName );
		if( value == null ) {
			return defaultValue;
		} else {
			return value.booleanValue();
		}
	}
	
	static public void setBooleanProperty( PropertyList propList, String propName, boolean value ) {
		propList.setProperty( propName, new Boolean( value ) );
	}
	
	
	
	static public float getFloatProperty( PropertyList propList, String propName ) {
		return getFloatProperty( propList, propName, 0.0f );
	}
	
	static public float getFloatProperty( PropertyList propList, String propName, float defaultValue ) {
		Float value = (Float) propList.getProperty( propName );
		if( value == null ) {
			return defaultValue;
		} else {
			return value.floatValue();
		}
	}

	static public void setFloatProperty( PropertyList propList, String propName, float value ) {
		propList.setProperty( propName, new Float( value ) );
	}
	

	
	static public double getDoubleProperty( PropertyList propList, String propName ) {
		return getDoubleProperty( propList, propName, 0.0 );
	}

	static public double getDoubleProperty( PropertyList propList, String propName, double defaultValue ) {
		Double value = (Double) propList.getProperty( propName );
		if( value == null ) {
			return defaultValue;
		} else {
			return value.doubleValue();
		}
	}

	static public void setDoubleProperty( PropertyList propList, String propName, double value ) {
		propList.setProperty( propName, new Double( value ) );
	}
	

	
}
